<?php
// Add new input type "textfield"
if ( function_exists('smile_add_input_type'))
{
	smile_add_input_type('textfield' , 'textfield_settings_field' );
}

/**
* Function to handle new input type "textfield"
*
* @param $settings		- settings provided when using the input type "textfield"
* @param $value			- holds the default / updated value
* @return string/html 	- html output generated by the function
*/
function textfield_settings_field($name, $settings, $value)
{
	$input_name = $name;
	$value = htmlspecialchars($value, ENT_QUOTES, "UTF-8");
	$type = isset($settings['type']) ? $settings['type'] : '';
	$class = isset($settings['class']) ? $settings['class'] : '';
	$output = '<p><input type="text" id="smile_'.$input_name.'" class="form-control smile-input smile-'.$type.' '.$input_name.' '.$type.' '.$class.'" name="' . $input_name . '" value="'.$value.'" /></p>';
	return $output;
}