<?php
// Add new input type "post-types"
if ( function_exists('smile_add_input_type'))
{
	smile_add_input_type('post-types' , 'post_types_settings_field' );
}

/**
* Function to handle new input type "post-types"
*
* @param $settings		- settings provided when using the input type "post-types"
* @param $value			- holds the default / updated value
* @return string/html 	- html output generated by the function
*/
function post_types_settings_field($name, $settings, $value)
{
	$input_name = $name;
	$type = isset($settings['type']) ? $settings['type'] : '';
	$class = isset($settings['class']) ? $settings['class'] : '';
	ob_start();
	?>
<select name="<?php echo esc_attr( $input_name ); ?>" id="smile_<?php echo esc_attr( $input_name ); ?>" class="select2-post-types-dropdown form-control smile-input <?php echo esc_attr( 'smile-'.$type.' '.$input_name.' '.$type.' '.$class ); ?>" multiple="multiple" style="width:260px;">
	<?php
	$selected = '';
	$val_arr = explode( ",", $value );
	$args = array(
	   'public'   => true,
	   '_builtin' => false
	);

	$output = 'names'; // names or objects, note names is the default
	$operator = 'and'; // 'and' or 'or'
    $public_post_types = get_post_types( $args, $output, $operator );

	$args = array(
	   'public'   => true,
	   '_builtin' => true
	);

	$output = 'names'; // names or objects, note names is the default
	$operator = 'and'; // 'and' or 'or'
    $builtin_post_types = get_post_types( $args, $output, $operator );

	$post_types = array_merge( $builtin_post_types, $public_post_types );

	?>
    <optgroup label="<?php echo __( "Post Types -", "smile" ); ?>"> <?php
		foreach ( $post_types as $post_type ) {
			$selected = ( in_array( $post_type, $val_arr) ) ? 'selected="selected"' : '';
			?> <option <?php echo $selected; ?> value="<?php echo esc_attr( $post_type) ; ?>"><?php echo ucwords( $post_type ); ?></option> <?php
		}
		?>
    </optgroup>
    <optgroup label="<?php echo __( "Taxonomies -", "smile" ); ?>">
		<?php
		$selected = '';
        $args = array(
           'public'   => true,
           '_builtin' => true
        );

        $output = 'objects'; // names or objects, note names is the default
        $operator = 'and'; // 'and' or 'or'
        $builtin_taxonomies = get_taxonomies( $args, $output, $operator );

        unset($builtin_taxonomies['post_format']);

        $args = array(
           'public'   => true,
           '_builtin' => false
        );

        $output = 'objects'; // names or objects, note names is the default
        $operator = 'and'; // 'and' or 'or'
        $public_taxonomies = get_taxonomies( $args, $output, $operator );

        $taxonomies = array_merge( $builtin_taxonomies, $public_taxonomies );

        foreach ( $taxonomies as $taxonomy ) {
			$selected = ( in_array( 'cp-'.$taxonomy->name, $val_arr) ) ? 'selected="selected"' : '';
            ?>  <option <?php echo $selected; ?> value="cp-<?php echo esc_attr( $taxonomy->name ); ?>"><?php echo ucwords( $taxonomy->label ); ?></option> <?php
        }
        ?>
    </optgroup>
</select>
<script type="text/javascript">
jQuery(document).ready(function() {
	jQuery('select.select2-post-types-dropdown').select2({
		 placeholder: "Select post types",
	});
});
</script>
    <?php
	return ob_get_clean();
}
